import os

def getGameRoot(filename: str):
    curDir = filename if os.path.isdir(filename) else os.path.dirname(filename)
    while (True):
        # if has Bin/Engine.dll - we found game root
        if (os.path.exists(os.path.join(curDir, "Bin", "Engine.dll"))):
            break
        # if walked up to mount - nowhere look anymore
        if (os.path.ismount(curDir)):
            return ""
        # go one dir up
        curDir = os.path.dirname(curDir)

    relPath = filename.replace(os.path.abspath(curDir), "")[1:]

    # if path contains Mods/<modname> - return mod root
    if (relPath.startswith("Mods" + os.path.sep)):
        return os.path.join(curDir, *relPath.split(os.path.sep)[:2])
    return curDir

def resolveRelativePath(absfp: str, relfp: str) -> str:
    split = os.path.normpath(relfp).split(os.path.sep)
    pos = 0
    while (True):
        pos = absfp.find(split[0], pos)
        if (pos == -1):
            return ""

        fp = absfp[:pos] + relfp
        if (os.path.exists(fp)):
            return fp

        pos += 1